var isIndex = require('./_isIndex');

/**
 * The base implementation of `_.nth` which doesn't coerce `n` to an integer.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} n The index of the element to return.
 * @returns {*} Returns the nth element.
 */
function baseNth(array, n) {
  var length = array.length;
  if (!length) {
    return;
  }
  n += n < 0 ? length : 0;
  return isIndex(n, length) ? array[n] : undefined;
}

module.exports = baseNth;
